import os
import sys
import imp
import time
from send import send
from send import ClientJob as Job
from send import Connect as Connect

mainpath = os.path.dirname(os.path.abspath(__file__))
cf = imp.load_source('loadConfigFile', '%s/%s'%(os.path.dirname(os.path.abspath(__file__)),'../config/loadConfigFile.py'))
configuration = None

def generate_aws_command(create=False,attache=False,submit=False,nfs=False,nfs_mount=None, nfs_volume=None, nfs_attach=None,job=None,host=None,owner="ubuntu",infile=None,outfile=None,cross=False,conf='cluster'):
	configuration = cf.loadConfig(conf)
	command = "python %s/EHPC-Client "%(os.path.dirname(os.path.abspath(__file__)))
	if create:
		region 			= configuration['AWS']['region']
		instance_type 	= configuration['AWS']['instance_type']
		master_type 	= configuration['AWS']['master_type']
		cluster_size 	= configuration['CLUSTER']['cluster_size']
		if cross:
			cluster_size 	= "1"
		image_id 		= configuration['IMAGE']['aws_image_id']
		security_group  = configuration['AWS']['securitygroup']
		nfs_mount 		= configuration['NFS']['aws_mount_point']
		nfs_size		= configuration['NFS']['aws_volume_size']
		nfs_device		= configuration['NFS']['aws_volume_device']
		nfs_volume_name = configuration['NFS']['aws_volume_name']
		
		command = "%s --create --conf=%s -r=%s -t=%s -n=%s -ami=%s -sg=%s"%(command,conf,region,instance_type, cluster_size,image_id, security_group)
		
		if nfs:
			if nfs_mount !=None:
				if nfs_volume !=None:
					# create new volume:
					command = "%s --nfs-mountPoint=%s --nfs-newVolume=%s" %(command,nfs_mount,nfs_size)
				elif nfs_device !=None:
					# attach exist volume:
					print "attach nfs volume"
					command = "%s --nfs-attchVolume=%s --nfs-device=%s"%(command,nfs_volume_name, nfs_device)
				else:
					print "Nothing to do with nfs"	
	elif submit:
		#submit a remote job to main node:
		command = "%s --job-submit --domain=%s "%(command, host)
	else:
		command = "ERROR"
	return command

def create_volume():
	global configuration, mainpath
	return "python %s/volumes --create-volume -r=%s -z=%s --private-Key=%s/conf/keys/%s --certificate=%s/conf/keys/%s "%(mainpath,configuration['AWS']['region'], configuration['AWS']['zone'],mainpath,configuration['AWS']['pkey'],mainpath,configuration['AWS']['cert'])

def delete_volume():
	global configuration, mainpath
	return "python %s/volumes --delete-volume -r=%s --private-Key=%s/conf/keys/%s --certificate=%s/conf/keys/%s "%(mainpath,configuration['AWS']['region'],mainpath,configuration['AWS']['pkey'],mainpath,configuration['AWS']['cert'])
def list_volumes():
	#volumes --lst-avaliable-volumes -r=EU1 -z=eu-west-1a
	global configuration, mainpath
	return "python %s/volumes --lst-avaliable-volumes -r=%s -z=%s --private-Key=%s/conf/keys/%s --certificate=%s/conf/keys/%s "%(mainpath,configuration['AWS']['region'], configuration['AWS']['zone'],mainpath,configuration['AWS']['pkey'], mainpath, configuration['AWS']['cert'])


def xplatform_command(domain,destination,owner,filepath,cross=False, gce=True):
	global configuration, mainpath
	if gce:
		upload_file(filepath,owner,destination,domain)
		command="python /opt/ehpc/manage-ehpc.py --create --provider=gce  --command --oauth=config/GCE.dat --count=%s --type=%s --region=%s --image=%s --project=%s --cluster=%s --kpair=keys/key --cross=cross.json "%(configuration['CROSS']['gce'], configuration['GCE']['instance_type'],configuration['GCE']['zone'], configuration['IMAGE']['gce_image_id'], configuration['GCE']['project_id'], configuration['CLUSTER']['cluster_prefix'])
		print command
		exit(0)
def upload_file(filepath,owner,destination,domain):
		global configuration, mainpath
		send.UploadFiles(domain,5000,'11',owner,[filepath],destination)

def crosspbs(domain):
	nodelist=""
	for i in range(1,int(configuration['CROSS']['gce'])):
		nodelist +='#%snode%s'%(configuration['CLUSTER']['cluster_prefix'],str(i)) 
	command = "python /opt/ehpc/gce/ehpcserver.py --pbs --node=Elastic-HPC-0 --project=%s --zone=%s --nodelist=Elastic-HPC-0%s --oauth=config/GCE.dat --command --crossPBS=%s --cross-master=aws"%(configuration['GCE']['project_id'],configuration['GCE']['zone'],nodelist,domain)
	print command

def check_token_time(file):
	now = time.time()
	fileCreation = os.path.getctime(file)
	delay = now - 20*60 # Number of seconds in two days
	if fileCreation < delay:
		print "File is more than 10 mins old"
		sys.exit()
def hybrid_cluster(domain,install,pbs,id,configFile):
	# UPLOAD CREDENTIALS
	working_dir , file = os.path.split(configFile)
	# GCE Credentials GCE.dat
	storage = "%s/%s"%(working_dir,configuration['GCE']['oauth_storage'])
	if int(configuration['CROSS']['gce']) >= 1:
		check_token_time(storage)
		send.UploadFiles(domain,5000,'2','root',[storage],"/opt/ehpc/config/")
		file, storageName= os.path.split(storage)
		send.sendNewJob(domain,5000,"1","root","mv /opt/ehpc/config/%s /opt/ehpc/config/GCE.dat"%(storageName))
	# Windows Azure Credentials
	if int(configuration['CROSS']['azure']) >= 1:
		send.UploadFiles(domain, 5000, '3', 'root',['%s/%s'%(working_dir, configuration['AZURE']['certificate_path']), '%s/%s'%(working_dir, configuration['AZURE']['pkfile']), '%s/%s'%(working_dir, configuration['AZURE']['cert_data_path'])], "/opt/ehpc/wazure/keys/")		
	send.UploadFiles(domain,5000,'2','root',[configFile],"/opt/ehpc/config/")
	if install:
		file, configName = os.path.split(configFile) 
		send.sendNewJob(domain,5000,"1","root","mv /opt/ehpc/config/%s /opt/ehpc/config/cluster.conf"%(configName))
		print "python /opt/ehpc/hybrid.py --install=%s --id=%s"%(domain,id)
		print send.sendNewJob(domain,5000,"1","root","python /opt/ehpc/hybrid.py --install=%s --id=%s"%(domain,id))
		#print "python /opt/ehpc/hybrid.py --install=%s --id=%s"%(domain,id)
	elif pbs:
		#print "python /opt/ehpc/hybrid.py --pbs"
		send.sendNewJob(domain,5000,"1","root","sudo python /opt/ehpc/hybrid.py --pbs")
	else:
		print "ERR: command is not found"
	
if __name__ == "__main__":
	args = sys.argv
	create = nfs_volume = nfs = nfs_attach = False
	volume=False
	deletevolume=False
	listvolume=False
	cross=False
	for arg in args:
		if '--create' == arg:
			create = True
		if '--nfsvolume' == arg:
			nfs_volume = True
			nfs = True
			nfs_attach = True
		if '--volume' == arg:
			volume=True
		if '--delete-volume' == arg:
			deletevolume=True
		if '--list-volume'==arg:
			listvolume=True
		if '--cross=' in arg:
			cross=True
			domain=arg.split('=')[1]
			owner="ubuntu"
			filepath="%s/../gce/config/GCE.dat"%(os.path.dirname(os.path.abspath(__file__)))
			destination="/opt/ehpc/config/"
			for arg in args:
				if '--owner=' in arg:
					owner = arg.split("=")[1]
				if '--filepath=' in arg:
					filepath = arg.split('=')[1]
				if '--destination=' in arg:
					destination = arg.split('=')[1]
			xplatform_command(domain,destination,owner,filepath,cross)
		if '--crossPBS=' in arg:
			# install cross PBS Torque:
			domain=arg.split('=')[1]
			crosspbs(domain)
		if '--hybrid' in arg:
			domain = storage = None
			install = pbs = False
			for arg in args:
				if '--domain=' in arg:
					domain = arg.split('=')[1]
				if '--storage=' in arg:
					storage= arg.split('=')[1]
				if '--install' in arg:
					install=True
				if '--pbs' in arg:
					pbs = True
				if '--id=' in arg:
					id = arg.split('=')[1]
				if '--conf=' in arg:
					__config_file = arg.split('=')[1]
					print __config_file
					configuration = cf.loadConfig(__config_file)
			if domain == None:
				print "ERROR: Exit"
			else: 
				hybrid_cluster(domain,install, pbs, id, __config_file)

		if '--conf=' in arg:
			__config_file = arg.split('=')[1]
			configuration = cf.loadConfig(__config_file)


	if create:
		configFile = None
		for arg in args:
			if '--cross' == arg:
				cross = True 
			if '--conf=' in arg:
				configFile = arg.split('=')[1]
		print configFile
		if configFile:
			#configFile = '/'.join(configFile.split('/')[-2:])
			print generate_aws_command(create=create,nfs=nfs, nfs_volume=nfs_volume, nfs_attach=nfs_attach, cross=cross,conf=configFile)
		else:
			print generate_aws_command(create=create,nfs=nfs, nfs_volume=nfs_volume, nfs_attach=nfs_attach, cross=cross,conf='cluster')
	if volume:
		print create_volume()
	if deletevolume:
		print delete_volume()
	if listvolume:
		print list_volumes()
