#!/usr/bin/python
import socket,base64,time,sys,subprocess
from Crypto.PublicKey import RSA
import ClientJob as Job,Connect
import os
from Crypto import Random
forceFiles=False
EOM="\n\n###"
port=5000
domain=""

def submitJob(domain,port,id,owner,command,inputs=None,outputs=None,retry=True):
	if inputs !=None:
		inputs_dir = []
		for i in inputs:
			inputs_dir.append(os.path.dirname(i)) 
		UploadFiles(domain,port,id,owner,inputs,inputs_dir[0])
	msg=Job.createJobMessage(id,owner,command.strip(),inputs,outputs,retry)
	Connect.domain	= domain
	Connect.port	= port
	res = Connect.Send(msg,retry) 
	return res

def checkStatus(domain,port,id,owner,waitTillCompleted=True,retry=True,sge=True, PBS=False):
	Connect.domain= domain
	Connect.port  = port
	status = Job.checkJobStatus(Connect,id,owner,waitTillCompleted,retry,sge,PBS)
	return status

def FetchOutput(domain,port,id,owner,outputs=None,retry=True):	
	if outputs!=None:
		status=checkStatus(domain,port,id,owner,False,retry)
		#print status
		with open('%s/../../tmp/mystatus.log'%(os.path.dirname(os.path.abspath(__file__))),'w') as fobj:
			fobj.write('status: %s\ndomain: %s\nport: %s \noutput: %s'%(status,domain,port,outputs))
		if status=='C' or status=='E' or status=='Q':
				outlist=FetchFiles(domain,port,id,outputs,owner,retry=retry)
				with open('%s/../../tmp/mystatus.log'%(os.path.dirname(os.path.abspath(__file__))),'a') as fobj:
					fobj.write('outlist: %s'%(str(len(outlist))))
				if len(outlist)==len(outputs):
					return outlist
				else:
					return "Error Occured while fetching output, please check job logs on the server"
		else:
			print "Job doesn't finish yet to get outFiles"
	else:
		return None

def run(excuter):
	
	PIPE=subprocess.PIPE
	p=subprocess.Popen(excuter,stdout=PIPE,stderr=PIPE,shell=True)
	p.wait()
	st=p.stderr.read()
	
	if (len(st)>0):
		return "ERR: " + st		
	return p.stdout.read()

def sendNewJob(domain, port,id,owner,command,inputs=None,outputs=None,retry=True):
	res=submitJob(domain, port,id,owner,command,inputs,outputs,retry)
	id=""
	import time
	time.sleep(15)
	if outputs!=None:
		outlist=FetchOutput(domain,port,id,owner,outputs,retry)
		if outlist!=None:
			return outlist

	if ('recieved' in res):
		id=res.split(":")[1]
		return id
	else:
		return res
sshKeyPath=""

def UploadFiles(domain,port,id,owner,files,outputDir):
	Connect.domain = domain
	Connect.port   = port
	retry = True
	for file in files:
		uploadData 	= Job.UploadFileData(id,owner,file,outputDir)
		res 	 	= Connect.Send(uploadData,retry)
	return res
		
def FetchFiles(domain,port,id,files,owner='ehpcuser',mode='auto',destination="",retry=True):
	Connect.domain=domain
	Connect.port  =port
	if (files !=None):
		if mode=="auto":
			if sshKeyPath!="":
				mode="scp"
			else:
				mode="xml"			
			print 'Decided to use ' + mode + " to transfer files"
		if mode=='xml':
			msg=Job.FetchOutput(id,owner,files)
			res = Connect.Send(msg,retry)
			outlist=Job.parseResponse(res)
			return outlist
		elif mode=='scp':
			for file in files:
				dest=""
				if destination=="":
					dest=os.path.dirname(os.path.abspath(file))
				else:
					dest=destination
				if not os.path.exists(dest):
					os.makedirs(dest)
				cmd='scp -r -i %s ehpcuser@%s:%s %s'%(sshKeyPath,domain,file,dest)
				scp(cmd)
			return files
	else:
		return "No Files"
