#! /usr/bin/python

import os
import sys
import ConfigParser

#print src_config._sections

def translate(new_conf,outDir):
	outFiles=[]
	
	src_config=ConfigParser.ConfigParser()
	src_config.read(new_conf)
	
	for cluster in src_config.get("CLUSTERS","CLUSTERS_LIST").split(","):
		config = ConfigParser.RawConfigParser()
		sections=["GCE","AZURE","AWS"]
		for section in sections:
			if src_config.has_section(section):
				config.add_section(section)
				options=src_config.options(section)
				for option in options:
					config.set(section,option,src_config.get(section,option))
		config.add_section("CLUSTER")
		config.set("CLUSTER","CLUSTER_PREFIX",src_config.get(cluster,"CLUSTER_NAME"))
		config.set("CLUSTER","CLUSTER_SIZE","")
		config.set("CLUSTER","NFS",src_config.get(cluster,"NFS"))
		if 	src_config.get(cluster,"NFS")=="True":
			config.add_section("NFS")
			config.set("NFS","MOUNTING_POINT",src_config.get(cluster,"NFS_MOUNTING_POINT"))
			config.set("NFS","DEVICE",src_config.get(cluster,"NFS_DEVICE"))
			config.set("NFS","FSID",src_config.get(cluster,"NFS_FSID"))
			config.set("NFS","AWS_VOLUME_SIZE",src_config.get(cluster,"NFS_FSID"))
			# attach new volume
			#AWS_VOLUME_SIZE=10
			#AWS_MOUNT_POINT=/gluster
			config.set("NFS","AWS_MOUNT_POINT",src_config.get(cluster,"NFS_MOUNTING_POINT"))
			config.set("NFS","AWS_VOLUME_DEVICE",src_config.get(cluster,"NFS_DEVICE"))
			config.set("NFS","AWS_VOLUME_NAME",src_config.get(cluster,"NFS_EBS_Mode"))	
			# in case of attach an exist volume NFS_EBS_Mode
			#AWS_VOLUME_DEVICE=
			#AWS_VOLUME_NAME=
			if src_config.get(cluster,"NFS_EBS_MODE")=="NEW_VOLUME":
				config.set("NFS","AWS_VOLUME_SIZE",src_config.get(cluster,"NFS_NEW_VOLUME_SIZE"))
			elif src_config.get(cluster,"NFS_EBS_MODE")=="EXISTING_VOLUME":
				config.set("NFS","AWS_VOLUME_NAME",src_config.get(cluster,"NFS_VOLUME_ID"))

		if src_config.get(cluster,"GLUSTER")=="True":	
			config.add_section("GLUSTERFS")
			config.set("GLUSTERFS","MOUNT_POINT",src_config.get(cluster,"GLUSTER_MOUNT_POINT"))
			config.set("GLUSTERFS","VOLUME_NAME",src_config.get(cluster,"GLUSTER_VOLUME_NAME"))
			config.set("GLUSTERFS","STRIPE",src_config.get(cluster,"GLUSTER_STRIPE"))
			config.set("GLUSTERFS","REPLICATE",src_config.get(cluster,"GLUSTER_MOUNT_POINT"))
			config.set("GLUSTERFS","FORMAT_DISK",src_config.get(cluster,"GLUSTER_MOUNT_POINT"))
		config.add_section("IMAGE")
		config.add_section("CROSS")
		config.add_section("DISK")
		
		config.set("CROSS","GCE",0)
		config.set("CROSS","AWS",0)
		config.set("CROSS","AZURE",0)
		config.add_section("FIREWALL")
			
		firewall={}
		for MachineSet in src_config.get(cluster,"MachineSets").split(","):		
			provider=src_config.get(MachineSet,"Provider").upper()
			config.set(provider,"INSTANCE_TYPE",src_config.get(MachineSet,"INSTANCE_TYPE"))
			config.set(provider,"MASTER_TYPE",src_config.get(MachineSet,"INSTANCE_TYPE"))
			config.set("IMAGE",provider+"_IMAGE_ID",src_config.get(MachineSet,"IMAGE_ID"))
			if provider.lower()=="azure":
				config.set("IMAGE","AZURE_DISK_URL",src_config.get(MachineSet,"AZURE_DISK_URL"))
			config.set("CROSS",provider,src_config.get(MachineSet,"NODES"))
			fnames=src_config.get(MachineSet,"FIREWALL").split("#")[0].split(",")
			fports=src_config.get(MachineSet,"FW_PORTS").split(",")
			fprotocols=src_config.get(MachineSet,"FW_PROTOCOLS").split(",")
			firwall={}
			for i in range(len(fnames)):
				firewall[fprotocols[i]+"-"+fports[i]]=fnames[i]	
			fnames=[]
			fports=[]
			fprotocols=[]
			if provider=="GCE":
				if src_config.has_option(MachineSet,"GCE_SNAPSHOT"):
					config.set("DISK","GCE_SNAPSHOT",src_config.get(MachineSet,"GCE_SNAPSHOT"))
					config.set("DISK","GCE_SNAPSHOT_PROJECT",src_config.get(MachineSet,"GCE_SNAPSHOT_PROJECT"))
			elif provider=="AZURE":
				config.set("DISK","DISK_NAME",src_config.get(MachineSet,"DISK_NAME"))
				config.set("DISK","DISK_ZONE",src_config.get(MachineSet,"DISK_ZONE") )
				config.set("DISK","DISK_INSTANCE",src_config.get(MachineSet,"DISK_INSTANCE") )
				config.set("DISK","DISK_NUMBER",src_config.get(MachineSet,"DISK_NUMBER") )
				config.set("DISK","DISK_SIZE",src_config.get(MachineSet,"DISK_SIZE") )
			
		for item in firewall.keys():
			fnames.append(firewall[item])
			fports.append(item.split("-")[1])
			fprotocols.append(item.split("-")[0])
		config.set("FIREWALL","FW_NAME",",".join(fnames))
		config.set("FIREWALL","FW_PORTS",",".join(fports))
		config.set("FIREWALL","FW_PROTOCOL",",".join(fprotocols))
		config.set("CROSS","MASTER",src_config.get(src_config.get(cluster,"MASTER_NODE_LOCATION"),"PROVIDER"))
		with open(outDir+"/"+cluster+".conf",'wb') as configfile:
			config.write(configfile)
			outFiles.append(outDir+"/"+cluster+".conf")
	import simplejson
	print ' '.join(outFiles)
	return simplejson.dumps(outFiles)
	
if __name__=="__main__":
	translate(sys.argv[1],sys.argv[2])
