#! /usr/bin/python

import os
import sys
import ConfigParser

#print src_config._sections

def translate(new_conf,outDir):
	outFiles=[]
	
	src_config=ConfigParser.ConfigParser()
	src_config.read(new_conf)
	cluster_size = 0
	for cluster in src_config.get("CLUSTERS","CLUSTERS_LIST").split(","):
		cluster_size = 0
		config = ConfigParser.RawConfigParser()
		sections=["GCE","AZURE","AWS"]
		for section in sections:
			if src_config.has_section(section):
				config.add_section(section)
				options=src_config.options(section)
				for option in options:
					config.set(section,option,src_config.get(section,option))
					
		# Cluster section
		config.add_section("CLUSTER")
		config.set("CLUSTER","CLUSTER_PREFIX",src_config.get(cluster,"CLUSTER_NAME"))
		for machineset in src_config.get(cluster, "MachineSets").split(','):
			cluster_size += int(src_config.get(machineset,"NODES"))
		config.set("CLUSTER","CLUSTER_SIZE",str(cluster_size))
		machineset = src_config.get(cluster, "MachineSets").split(',')[0]
		provider = src_config.get(machineset,'PROVIDER')
		config.set("CLUSTER","PROVIDER",provider)
		config.set("CLUSTER","NFS",src_config.get(cluster,"NFS"))
		# Gluster FS Section
		config.add_section("GLUSTERFS")
		if src_config.get(cluster,"GLUSTER")=="True":
			config.set("GLUSTERFS","MOUNT_POINT",src_config.get(cluster,"GLUSTER_MOUNT_POINT"))
			config.set("GLUSTERFS","VOLUME_NAME",src_config.get(cluster,"GLUSTER_VOLUME_NAME"))
			config.set("GLUSTERFS","STRIPE",src_config.get(cluster,"GLUSTER_STRIPE"))
			config.set("GLUSTERFS","REPLICATE",src_config.get(cluster,"GLUSTER_MOUNT_POINT"))
			config.set("GLUSTERFS","FORMAT_DISK",src_config.get(cluster,"GLUSTER_MOUNT_POINT"))
		else:
			config.set("GLUSTERFS","MOUNT_POINT","")
			config.set("GLUSTERFS","VOLUME_NAME","")
			config.set("GLUSTERFS","STRIPE","")
			config.set("GLUSTERFS","REPLICATE","")
			config.set("GLUSTERFS","FORMAT_DISK","")
		# NFS Section
		config.add_section("NFS")
		if src_config.get(cluster,"GLUSTER")=="True":
			config.set("NFS","MOUNTING_POINT",src_config.get(cluster,"NFS_MOUNTING_POINT"))
			config.set("NFS","DEVICE",src_config.get(cluster,"NFS_DEVICE"))
			config.set("NFS","FSID",src_config.get(cluster,"NFS_FSID"))
			config.set("NFS","AWS_VOLUME_SIZE",src_config.get(cluster,"NFS_NEW_VOLUME_SIZE"))
			config.set("NFS","AWS_MOUNT_POINT",src_config.get(cluster,"NFS_MOUNTING_POINT"))
			config.set("NFS","AWS_VOLUME_DEVICE",src_config.get(cluster,"NFS_VOLUME_ID"))
			config.set("NFS","AWS_VOLUME_NAME",src_config.get(cluster,"NFS_EBS_Mode"))
		else:
			config.set("NFS","MOUNTING_POINT","")
			config.set("NFS","DEVICE","")
			config.set("NFS","FSID","")
			config.set("NFS","AWS_VOLUME_SIZE","")
			config.set("NFS","AWS_MOUNT_POINT","")
			config.set("NFS","AWS_VOLUME_DEVICE","")
			config.set("NFS","AWS_VOLUME_NAME","")
		# Data Disks:
		config.add_section("DISK")
		config.set("DISK","GCE_SNAPSHOT", "")
		config.set("DISK","GCE_SNAPSHOT_PROJECT", "")
		config.set("DISK","AZURE_DISK_URL", "")
		config.set("DISK","DISK_NAME", "")
		config.set("DISK","DISK_INSTANCE", "")
		config.set("DISK","DISK_NUMBER", "")
		config.set("DISK","DISK_SIZE", "")
		for machineset in src_config.get(cluster, "MachineSets").split(','):
			if src_config.get(machineset,'PROVIDER') == 'GCE':
				config.set("DISK","GCE_SNAPSHOT", src_config.get(machineset, "GCE_SNAPSHOT"))
				config.set("DISK","GCE_SNAPSHOT_PROJECT", src_config.get(machineset, "GCE_SNAPSHOT_PROJECT"))
			if src_config.get(machineset,'PROVIDER') == 'AZURE':
				config.set("DISK","AZURE_DISK_URL", src_config.get(machineset, "AZURE_DISK_URL"))
				config.set("DISK","DISK_NAME", src_config.get(machineset, "DISK_NAME"))
				config.set("DISK","DISK_ZONE", src_config.get(machineset, "DISK_ZONE"))
				config.set("DISK","DISK_INSTANCE", src_config.get(machineset, "DISK_INSTANCE"))
				config.set("DISK","DISK_NUMBER", src_config.get(machineset, "DISK_NUMBER"))
				config.set("DISK","DISK_SIZE", src_config.get(machineset, "DISK_SIZE"))	 
		# Firewall Section
		config.add_section("FIREWALL")
		for machineset in src_config.get(cluster, "MachineSets").split(','):
			config.set("FIREWALL","FW_NAME", src_config.get(machineset, "FIREWALL"))
			config.set("FIREWALL","FW_PORT", src_config.get(machineset, "FW_PORTS"))
			config.set("FIREWALL","FW_PROTOCOL", src_config.get(machineset, "FW_PROTOCOLS"))
		# Image Section
		config.add_section("IMAGE")
		config.set("IMAGE","GCE_IMAGE_ID", "")
		config.set("IMAGE","AWS_IMAGE_ID", "")
		config.set("IMAGE","AZURE_IMAGE_ID", "")
		config.set("IMAGE","AZURE_OS_URL", "")
		
		for machineset in src_config.get(cluster, "MachineSets").split(','):
			if src_config.get(machineset,'PROVIDER') == 'GCE':
				config.set("IMAGE","GCE_IMAGE_ID", src_config.get(machineset,"IMAGE_ID"))
			if src_config.get(machineset,'PROVIDER') == 'AWS':
				config.set("IMAGE","AWS_IMAGE_ID", src_config.get(machineset,"IMAGE_ID"))
			if src_config.get(machineset,'PROVIDER') == 'AZURE':
				config.set("IMAGE","AZURE_IMAGE_ID", src_config.get(machineset,"IMAGE_ID"))
				config.set("IMAGE","AZURE_OS_URL", src_config.get(machineset,"OS_URL"))		
		
		# Service Section
		config.add_section("SERVICE")
		# modify instance type:
		for machineset in  src_config.get(cluster, "MachineSets").split(','):
			if src_config.get(machineset,'PROVIDER') == 'GCE':
				config.set("GCE","INSTANCE_TYPE",src_config.get(machineset,'INSTANCE_TYPE'))
			if src_config.get(machineset,'PROVIDER') == 'AWS':
				config.set("AWS","INSTANCE_TYPE",src_config.get(machineset,'INSTANCE_TYPE'))
			if src_config.get(machineset,'PROVIDER') == 'AZURE':
				config.set("AZURE","INSTANCE_TYPE",src_config.get(machineset,'INSTANCE_TYPE'))
		# Cross Section
		config.add_section("CROSS")
		config.set("CROSS","GCE",0)
		config.set("CROSS","AWS",0)
		config.set("CROSS","AZURE",0)
		config.set("CROSS","ACTIVE","False")
		config.set("CROSS","MASTER",src_config.get(src_config.get(cluster,"MASTER_NODE_LOCATION"),"PROVIDER").lower())
		if len(src_config.get(cluster, "MachineSets").split(',')) > 1:
			for machineset in  src_config.get(cluster, "MachineSets").split(','):
				if src_config.get(machineset,'PROVIDER') == 'GCE':
					config.set("CROSS","GCE",src_config.get(machineset,'NODES'))
				if src_config.get(machineset,'PROVIDER') == 'AWS':
					config.set("CROSS","AWS",src_config.get(machineset,'NODES'))
				if src_config.get(machineset,'PROVIDER') == 'AZURE':
					config.set("CROSS","AZURE",src_config.get(machineset,'NODES'))
				config.set("CROSS","ACTIVE","True")
		with open(outDir+"/"+cluster+".conf",'wb') as configfile:
			config.write(configfile)
			outFiles.append(outDir+"/"+cluster+".conf")
	return outFiles


if __name__=="__main__":
	translate(sys.argv[1],sys.argv[2])
