import os
import sys
_PWD = os.path.dirname(os.path.abspath(__file__))

def getHosts(master_ip,getObjects,single=False, hybrid=False, tmpDir=None):
	"""
	get hosts details and specs then save them to HostsFile:
		- instance id
		- hostname
		- public DNS
		- Region of master node
		- Number of cores in cluster
		- Cluster initialization time
	returns:
		message that discribes the status of returned data.
		
	"""
	if tmpDir !=None:
		outputFile = '%s/hostsFile.txt'%(tmpDir)
	else:
		outputFile = '%s/hostsFile.txt'%(_PWD)
	try:
		output = _get_master_details(master_ip, getObjects)
	except:
		return 'ERROR: unable to get cluster details'
	if output:
		print outputFile
		hostsObj = open(outputFile,'w')
		for key in output:
			hostsObj.write(key)
		hostsObj.close()
		return "INFO -- Hosts data is saved"
	else:
		print 'ERROR: unable to get hosts details'

def _get_master_details(master_ip, getObjects):
	"""
	Get Hosts.list file from master node then formulate the output to match the order:
	return :
		list of cluster info.
	"""
	try:
		_output = getObjects.sendNewJob(master_ip,5000,"1","root","cat /opt/ehpc/hosts.list")
		print _output
	except:
		print "ERROR: Unable to connect host %s"%(master_ip)
		return False
	output = _output.split('\n')
	for line in output:
		if 'Elastic-HPC-0' in line:
			return line
	return False
	
