import os
import sys
import execute

_PWD_ = os.path.dirname(os.path.abspath(__file__))

# create EBS Volume From Snanpshot
def _createEBSFromSnapshot(region, zone,snapshot_id,privateKey,cert):
    return execute._execute('%s/aws/volumes --create-volume -r=%s -z=%s -snap=%s -pk=%s -cert=%s'%(_PWD_, region, zone, snapshot_id, privateKey, cert))

# create Empty EBS Volume     
def _createEmptyEBSVolume(region, zone,size,privateKey,cert):
	return execute._execute('%s/aws/volumes --create-volume -r=%s -z=%s -s=%s -pk=%s -cert=%s'%(_PWD_, region, zone, snapshot_id, privateKey, cert))

# Delete EBS Volume
def _deleteEBSVolume(region, volume_id, privateKey, cert):
	return execute._execute('%s/aws/volumes --delete-volume -r=%s -id=%s -pk=%s -cert=%s'%(_PWD_, region, volume_id, privateKey, cert))

# create Persistant Disks 
def _createPersitantDiskFromSnapshot(configuration):
	return execute._execute('%s/gce/ehpc-client --disk -n=%s -p=%s --snapshot --command --source=%s'%(_PWD_, configuration['DISK']['disk_name'],configuration['GCE']['project_id'], configuration['DISK']['gce_snapshot']))

# create Empty Persistant Disk
def _createEmptyPersistantDisk(configuration):
	return execute._execute('%s/gce/ehpc-client --disk -n=%s -p=%s -s=%s'%(_PWD_, configuration['DISK']['disk_name'],configuration['GCE']['project_id'], configuration['DISK']['disk_size']))
	
#def _createVirtualDiskFromSnapshot(configuration):
	
#def _createEmptyVirtualDisk(configuration):
