#!/usr/bin/python
import os
import sys
import execute
# this module is used to create a fully configured cluster 
# using single command line

EHPC_ROOT = os.path.dirname(os.path.abspath(__file__))
start_mode = False
create_disk_snapshot = False
create_blank_disk = False
sge = False
attach_disk = False
glusterFS = False
NFS = False
terminate=False
project_id = 'direct-mason-545'
oauth = 'config/GCE.dat'
image_id = 'elastichpc-pbs1'
region = 'us-central1-a'
cluster_prefix = 'ehpc'
logfile = 'output'
machine_type = 'f1-micro'
count = '2'
disk_name= 'mydisk'
source_disk=""
disk_size = '10'

#python $EHPC_ROOT/gce/ehpc-client --command --oauth=config/GCE.dat --count=2 --type=f1-micro --region=us-central1-a --image=elastichpc-pbs1 --project=direct-mason-545 --cluster=cluster --kpair=keys/key --create --log=<filename>

#./ehpc-client --disk --snapshot --diskname=markdups-copy --source=markdups-data --project=direct-mason-545 --command --oauth=config/GCE.dat

#./ehpc-client --disk --diskname=markdups-copy --size=10 --project=direct-mason-545 --command --oauth=config/GCE.dat

#./ehpc-client --disk --attach --instance=hpcnode0 --diskname=markdups-copy --zone=us-central1-a --command --project=direct-mason-545 --oauth=config/GCE.dat

def submit_args(args):
	global EHPC_ROOT,start_mode, create_disk_snapshot, create_blank_disk, sge, attach_disk, glusterFS, NFS ,terminate, project_id, oauth, image_id, region, cluster_prefix, logfile, machine_type, count, disk_name, source_disk, disk_size 
	for arg in args:
		# python EHPC-Client.py --start --project=direct-mason-545 --oauth=config/GCE.dat 
		if '--start' == arg:
			start_mode = True
		if '--snapshot' == arg:
			create_disk_snapshot = True
		if '--blank-disk' == arg:
			create_blank_disk = True
		if '--sge' == arg:
			sge = True
		if '--attach' == arg:
			attach_disk = True
		if '--nfs' == arg:
			NFS = True
		if '--gluster' == arg:
			glusterFS = True
		if '--terminate' == arg:
			terminate=True
		if '--project=' in arg:
			project_id = arg.split('=')[1] 
		if '--oauth=' in arg:
			oauth = arg.split('=')[1]
		if '--image=' in arg:
			image_id = arg.split('=')[1]
		if '--region=' in arg:
			region = arg.split('=')[1]
		if '--cluster=' in arg:
			cluster_prefix = arg.split('=')[1]
		if '--type=' in arg:
			machine_type = arg.split('=')[1]
		if '--count=' in arg:
			count = arg.split('=')[1]
		if '--diskname=' in arg:
			disk_name = arg.split('=')[1]
		if '--source_disk=' in arg:
			source_disk = arg.split('=')[1]
		if '--disk-size=' in arg:
			disk_size = arg.split('=') 
		if '--log=' in arg:
			logfile = arg.split('=')[1]

def cluster_manager():
	global EHPC_ROOT,start_mode, create_disk_snapshot, create_blank_disk, sge, attach_disk, glusterFS, NFS ,terminate, project_id, oauth, image_id, region, cluster_prefix, logfile, machine_type, count, disk_name, source_disk, disk_size
	if start_mode:
		execute._execute("python %s/gce/ehpc-client --command --oauth=%s --count=%s --type=%s --region=%s --image=%s --project=%s --cluster=%s --kpair=keys/key --create --log=%s"%(EHPC_ROOT,oauth,count,machine_type, region, image_id, project_id, cluster_prefix, logfile))
	if create_disk_snapshot:
		execute._execute("python %s/ehpc-client --disk --snapshot --diskname=%s --source=%s --project=%s --command --oauth=%s"%(EHPC_ROOT,disk_name, source_disk, project_id, oauth))
	if create_blank_disk:
		execute._execute("python %s/ehpc-client --disk --diskname=%s --size=%s --project=%s --command --oauth=%s"%(EHPC_ROOT, disk_name, disk_size, project_id, oauth))

	if attach_disk:
		execute._execute("python %s/ehpc-client --disk --attach --instance=%snode0 --diskname=%s --zone=%s --command --project=%s --oauth=%s"%(EHPC_ROOT, cluster_prefix, disk_name, region, project_id, oauth))

if __name__ == '__main__':
	submit_args(sys.argv[1:])
