#!/usr/bin/env python
import argparse
import sys, os, time
import subprocess
import logging as log
from config import loadConfigFile as cf
sys.path.append(os.path.abspath("mcgenomekey"))
#from _mcgenomekey import readConfig, execute
import ConfigParser


PWD = os.path.dirname(os.path.abspath(__file__))
sys.path.append(PWD)
GK_INPUT_DIR = "/cosmos_input"
GK_LOG = "/cosmos_output"
#GK_LOG = "/home/ehpcuser/filo.log"
GK_OUT_DIR = "/cosmos_output"
#GK_OUT_DIR = "/home/ehpcuser/filo.log"
OBJ_STORE = "S3"

SGE_ENV = "export SGE_ROOT=/opt/sge6-fresh;export SGE_CELL=default;\
		   export JAVA_HOME=/usr/lib/jvm/jdk1.8.0_05/;\
           export DRMAA_LIBRARY_PATH=/opt/sge6-fresh/lib/linux-x64/libdrmaa.so;\
           export PATH=$SGE_ROOT/bin/linux-x64:$PATH;export MANPATH=$MANPATH:$SGE_ROOT/man:"


class bcolors:
    HEADER = '\033[95m'
    OKBLUE = '\033[94m'
    OKGREEN = '\033[92m'
    WARNING = '\033[93m'
    FAIL = '\033[91m'
    ENDC = '\033[0m'
    BOLD = '\033[1m'
    UNDERLINE = '\033[4m'

def parse_args():		
	parser = argparse.ArgumentParser()
	parser.add_argument('-v', '--verbose', action="store_true", help="run in verbose mode")
	
	subparser = parser.add_subparsers(title="Commands", metavar="<command>")
	
	create_parser = subparser.add_parser('create', help="create multicloud cluster")
	create_parser.add_argument('--ehpc_conf', type=str, metavar="<elasticHPC conf file>", help="elasticHPC configruation file", required=True)
	
	create_parser.set_defaults(func=create_cluster)

	terminate_parser = subparser.add_parser('terminate', help="terminate cluster")
	terminate_parser.add_argument('-d', '--domain', metavar="<master node ip>", type=str, help="master node ip", required=True)

	terminate_parser.set_defaults(func=terminate_cluster)
	
	status_parser = subparser.add_parser('status', help="get status of cluster")
	status_parser.add_argument('--conf', metavar="<cluster file>", help="cluster configuration file", required=True)
	status_parser.add_argument('-d', '--domain', metavar="<master node ip>", help="master node ip", required=True)
	
	status_parser.set_defaults(func=status)
	
	submit_parser = subparser.add_parser('submit', help="submit a job to a cluster")
		
	submit_parser.add_argument('-d', '--domain', type=str, help="master node domain", required=True)
	"""
	submit_parser.add_argument('-n', '--wfname', type=str, help="Workflow name", required=True)
	submit_parser.add_argument('--bucket', type=str, nargs="?", help="S3 bucket")
	submit_parser.add_argument('--object', type=str, nargs="?", help="S3 object")		
	submit_parser.add_argument('-i', '--pubinput', type=str, nargs="?", help="input path on public aws s3")
	submit_parser.add_argument('--s3output', type=str, help="output bucket on aws s3", required=True)
	submit_parser.add_argument('--ehpc_conf', type=str, help="ElasticHPC conf file", required=True)
	"""
	submit_parser.set_defaults(func=submit)
	
	args = parser.parse_args()
	kwargs = dict(args._get_kwargs())

	"""
	if "submit" in sys.argv and not ((kwargs["pubinput"] or (kwargs["bucket"] and kwargs["object"])) and ( kwargs["s3output"])):
		submit_usage("Invalid arguments.")
		sys.exit(2)
	elif sys.argv[1] == "submit" and not kwargs["id"]:
		submit_usage("Invalid command. Expected job id.")
		sys.exit(2)
	elif sys.argv[1] == "submit" and not kwargs["domain"]:
		submit_usage("Invalid command. Expected master node domain.")
		sys.exit(2)	
	"""
	return args, kwargs

def readConfig(configFile):
	config = ConfigParser.RawConfigParser()
	config.read(configFile)

	dict={}

	dict['wfname'] = config.get('workflow', 'name')
	dict['recov'] = config.get('recovery', 'method')
	if dict['recov'] == 'migrateAll' or dict['recov'] == 'migrateFailed':
		dict['gce_conf'] = os.path.abspath(config.get('recovery', 'gce_conf_path'))
	dict['s3_type'] = config.get('input', 's3_type')
	if dict['s3_type'] == 'public':
		dict['link'] = config.get('public', 'link')
	elif dict['s3_type'] == 'private':
		dict['bucket'] = config.get('private', 'bucket')
		dict['object'] = config.get('private', 'object')
		dict['sk'] = config.get('private', 'secretkey')
		dict['ak'] = config.get('private', 'accesskey')

	dict['output_dir'] = config.get('output', 'directory')
	dict['output'] = config.get('output', 'bucket')
	
	return dict


def execute(command, wait=True):
	PIPE = subprocess.PIPE
	p = subprocess.Popen(command, stdout=PIPE, stderr=PIPE, shell=True)
	if(wait):
		p.wait()
		stderr_stream = p.stderr.read()

		if(len(stderr_stream) > 0):
			run("echo \'ERROR -- {0}\' >> {1}".format(stderr_stream, 'mcgk.log'))
			#raise Exception("ERROR -- " + stderr_stream)

		stdout_stream = p.stdout.read()
		run('ehco \'{0}\' >> {1}'.format(stdout_stream, 'mcgk.log'))	
		return stdout_stream


def readStatus(status_file, delimiter, exit_status=""):
	lines = []

	while(1):
		recent_index = len(lines)
		recent_lines = read(status_file)
		if len(recent_lines) != recent_index:
			print "\n".join(recent_lines[recent_index:])
			lines = recent_lines
			
			if exit_status in lines[-1]:
				sys.exit(2)
			elif delimiter in lines[-1]:
				break	

				
		time.sleep(3)
		
def read(status_file):
	beauty_list = []
	with open(status_file) as st:
		recent_lines = st.readlines()
	for line in recent_lines:
		if line != "\n":
			beauty_list.append(line.replace("\n", ""))
						
	return beauty_list	


def readSubmitStatus(status_file, delimiter, recent_index, err_delimiter="ta-ta"):
	lines = read(status_file)
			
	if recent_index == len(lines):
		return recent_index
	
	print "\n".join(lines[recent_index:])
	
	if delimiter in "\n".join(lines):
		return -1
	else:
	 for msg in err_delimiter.split():
		if msg in "\n".join(lines):
			sys.exit(2)
		
	return len(lines)
			

def getStatusFile(ehpc_conf, file_name=""):
	cwd = os.path.dirname(ehpc_conf)
	status_file = os.path.join(cwd, file_name)
	return status_file


def format_lines(lines):
	for line in lines:	
		line_frags = line.split(" ")
		if "INFO" == line_frags[0]:
			line_frags[0] = bcolors.OKGREEN + "INFO" + bcolors.ENDC
		elif "ERROR" == line_frags[0]:
			line_frags[0] = bcolors.FAIL + "ERROR" + bcolors.ENDC
		elif "WARNING" == line_frags[0]:
			line_frags[0] = bcolors.WARNING + "WARNING" + bcolors.ENDC
		line = (" ").join(line_frags).replace("\n", "")
	
	return lines
	

def create_cluster(ehpc_conf, **kwargs):
	#with open('../tmp/create') as ct:
	#	lines = ct.readlines()
	#raise Exception(ehpc_conf)
	#lines = read('../tmp/create')	
	#time.sleep(5)	
	#print "\n".join(lines)
	#sys.exit(2)
###
	
	status_file = getStatusFile(ehpc_conf, "status.log")
	cmd = "python %s --cross --create --conf=%s" % (os.path.join(PWD, "ehpcutils"), ehpc_conf)
	run("touch %s" % status_file)
	
	if kwargs["verbose"]:
		cmd += "&"
		os.system(cmd)
		readStatus(status_file, "INFO -- check out GenomeKey Workflow on", "ERROR --")	
	else:
		os.system(cmd)

	#to get the domain from the link -last line in status file-	
	with open(status_file) as st:
		link = st.readlines()[-1]
		
	if "INFO -- check out GenomeKey Workflow on" in link:
		domain = link.split(":")[1].split("//")[1]		
		interface_cmd = "./ehpcutils --submit --command=\"cosmos runweb -p 8080&\" --domain=%s --owner=ehpcuser --id=%s &" % (domain, generate_id())
		os.system(interface_cmd)
		"""
		time.sleep(5)
		import webbrowser
		webbrowser.get("firefox").open("http://%s:8080/Workflow/"%(domain))
		"""

def pull_inputs(**kwargs):
	if kwargs["pubinput"]:
		input = kwargs["pubinput"]
		input_file_name = input.split("/")[-1]
		cmd = "./ehpcutils --submit --command=\"cd %s; wget %s\" --domain=%s --owner=ehpcuser --id=%s" % (GK_INPUT_DIR, input, domain, generate_id())
		try:
			os.system("%s > /tmp/public_download" % (cmd))
		except:
			logger.error("ERROR -- Failed to download input: '%s', output: '%s' " % (input_path, output_path))

		gk_cmd = "bash /home/ehpcuser/gk.sh %s %s" % (wfname, os.path.join(GK_INPUT_DIR, input_file_name))

	else: #case2
		#./S3Services download --secret  --access  --bucket genomekeybucket --object read_me --destination /home/ahmed/
		bucket = kwargs["bucket"]
		object = kwargs["object"]
		
		if "bam" not in object:
			raise Exception('ERROR -- Input file should be of type bam')
		
		logger.info("Downloading %s from %s" % (object, OBJ_STORE))
		
		cmd = "./ehpcutils --submit --command=\"python /opt/ehpc/S3Services download --secret %s --access %s --bucket %s --object %s --destination %s\" --domain=%s --owner=ehpcuser --id=%s " % (secretkey, accesskey, bucket, object, GK_INPUT_DIR, domain, generate_id())
		out, err = run(cmd)
		
		if err:
			raise Exception(err)
		else:
			logger.info("Downloading Successful")

def input_exists(domain, input):
	check_exist = "ssh -i gce/keys/pkey ehpcuser@{0} ls /cosmos_input/".format(domain)
	print check_exist
	value = execute(check_exist)
	#print "value = " + value
	if input not in value:
		return 0
	else:
		#print "ho"
		return 1	
	
def submit(domain, wfname, logger="mcgk", **kwargs):
    """
	lines = read('../tmp/submit')	
	#time.sleep(5)	
	print "\n".join(lines)
	sys.exit(2)
    """
    #raise Exception(logger)
    params = readConfig("job_conf.conf")

    job_id = generate_id(1000, 2000)
    
    params["wfname"] = wfname
    
    check_exist = "ssh -i gce/keys/pkey ehpcuser@{0} ls /cosmos_input/".format(domain)
    value = execute(check_exist)

    if params["object"] not in value:
        print "input no exist"
        cp_input = "ssh -i gce/keys/pkey ehpcuser@{0} cp /home/ehpcuser/latest/genomekey/test/BGI/120099.v2.bam /cosmos_input/{1}".format(domain, params["object"])
        execute(cp_input)

    global GK_LOG 
    GK_LOG = os.path.join(GK_LOG, "%s/log/main.log" % (params["wfname"]))
    print GK_LOG
    gk_cmd = ""
    #/gluster/WGA/gv0/WGA/cosmos_output/wf1/log/main.log

    gk_cmd = "bash /opt/ehpc/gk.sh %s %s" % (params["wfname"], os.path.join(GK_INPUT_DIR, params["object"]))
	
    job_id = generate_id(1000, 2000)
	
    print "INFO -- Starting Genomekey job (id = %s)" % (job_id)
    start_cmd = "ssh -i gce/keys/pkey ehpcuser@{0} \"{1}\" > gk.log &".format(domain, gk_cmd)
    execute(start_cmd, wait=False)
    print "here"
    gk_stats = "gk.log"
    os.system("touch %s" % (gk_stats))
    
    while(True):
		print "hh"
		time.sleep(10)
		cmd = "ssh -i gce/keys/pkey ehpcuser@{0} ps aux | grep [g]k".format(domain)
		out = execute(cmd)
		print out
		if out:
			break
		else:
		    execute(start_cmd, wait=False)

		
		
    recent = 0
    while(1):
		time.sleep(5)
			
		gk_log_cmd = "ssh -i gce/keys/pkey ehpcuser@{0} \'cat {1}\' > {2}".format(domain, GK_LOG, gk_stats)
		print gk_log_cmd
		os.system(gk_log_cmd)
			
		recent = readSubmitStatus(gk_stats, "Finished Workflow", recent, "Exiting Terminate")
		if recent == -1:
			break
    
    os.chdir("/var/www/mcgk/mcGenomekey-0.1.1")
    os.path.join(os.path.dirname(__file__), logger)
    wf_dir = os.path.join(GK_OUT_DIR, params["wfname"])
    output_tar_path = os.path.join(wf_dir, "%s.out.tar.gz" % (job_id))
    
    if logger:
       os.system("echo \">>> compressing output directory\" >> {0}".format(logger))
    else:
       print "INFO -- compressing output directory"
    compress_cmd = "./ehpcutils --submit --command=\"cd %s; tar -zcf %s %s\" --domain=%s --owner=ehpcuser --id=%s &" % (wf_dir, output_tar_path, params["output_dir"], domain, generate_id())
    os.system(compress_cmd)


    if logger:
       os.system("echo \">>> uploading genomekey output tar -{0}- to output bucket: {1}\" >> {2}".format(output_tar_path, params["bucket"], logger))
    else:	
       print "INFO -- uploading genomekey output tar -%s- to output bucket: %s" % (output_tar_path, params["bucket"])

    upload_cmd = "./ehpcutils --submit --command=\"python /opt/ehpc/S3Services upload --secret %s --access %s --bucket %s --object %s\" --domain=%s --owner=ehpcuser --id=%s" % (params["sk"], params["ak"], params["bucket"], output_tar_path, domain, generate_id())
    print upload_cmd
    os.system(upload_cmd)

    sys.exit(0)

    if logger:
       os.system("echo \">>> Done\" >> {0}".format(logger))
    else:
       print "INFO -- done"

	
def gk_job_status(domain):
	cmd = "./ehpcutils --submit --command=\"pgrep -c \"genomekey\"\" --domain=%s --owner=ehpcuser --id=%s" % (domain, generate_id())
	out, err = run(cmd)
	if out >= 1:
		print "INFO -- No Genomekey job is running"
	else:
		print "INFO -- Genomekey job is running"
		
	
def terminate_cluster(domain, **kwargs):
	#lines = read('../tmp/terminate')	
	#time.sleep(5)	
	#print "\n".join(lines)
	#sys.exit(2)
	print "INFO -- Terminating cluster" 
	cmd = "./ehpcutils --terminate --master=%s" % (domain)
	os.system(cmd)	
	
def status(conf, domain, **kwargs):
	#lines = read('../tmp/status2')	
	#time.sleep(5)	
	#print "\n".join(lines)
	#sys.exit(2)	
	cmd = "touch %s/cluster_status.log ;./ehpcutils --status --conf=%s --domain=%s &" % (os.path.dirname(os.path.abspath(conf)),conf, domain)
	try:
		os.system(cmd)
	except:
		print 'ERROR -- mater node "%s" is not reachable' %(domain)
	status_file = getStatusFile(conf, "cluster_status.log")
	gk_job_status(domain)
	readStatus(status_file, "INFO -- done")


def run(cmd):
	proc = subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)
	(out, err) = proc.communicate()
	return (out, err)

def get_domain(ehpc_conf):
	status_file = getStatusFile(ehpc_conf, "status.log")
	with open(status_file) as st:
		lines = st.readlines()
	domain = lines[-1].split(" ")[-1].split("http://")[1]
	return domain
				

def generate_id(a=1, b=100):
	from random import randint
	return str(randint(a, b))
	
def s3_exist(file_path):
	print "checking file %s exists on s3" % (file_path)
	cmd = 'aws s3 ls %s' % (file_path)
	(out, err) = run(cmd)

	if err:
		raise Exception(err)
	if out is None:
		raise Exception("%s doesnt exist. Aborting" % (file_path))
	return True
	
def get_keys(ehpc_conf):
	conf = cf.loadConfig(ehpc_conf)

	try:
		accesskey = conf["AWS"]["accesskey"]
		secretkey = conf['AWS']['secretkey']
	except:
		print "ERROR -- AWS access and secret keys not found"
		sys.exit(2)		
	
	return (secretkey, accesskey)	
		

def main():
	args, kwargs = parse_args()
	#print "kwargs = " + str(kwargs['func'])

	kwargs['func'](**kwargs)


if __name__ == '__main__':
	main()
