#!/usr/bin/python
import socket,base64,time,sys,subprocess,ConfigParser,MySQLdb,os
import ClientJob as Job,Connect
domain=""
mainPath=os.path.dirname(os.path.abspath( __file__ ))+'/'
logFile=""

def _insert(st):
	
	db = connectToDB()
	cursor=db.cursor()
	cursor.execute(st)
	db.commit()
	cursor.close ()
	db.close()
def connectToDB():
	return MySQLdb.connect(host=config.DBHost,port=int(config.DBPort), user=config.DBUserName, passwd=config.DBPassword,db=config.DB)
	
def sendNewJob(domain,id,owner,command,inputs=None,outputs=None):
	msg=Job.createJobMessage(id,owner,command.strip(),inputs,outputs)
	#print msg
	Connect.domain=domain
	print Connect.domain
	res = Connect.Send(msg)
	#print "Server replied " + res
	if ("Done" in res):
		return "Done"
	if ('recieved' in res):
		print res
		id=res.split(":")[1]
	#	print "NewID: " + id
		status = Job.checkJobStatus(Connect,id,owner)
		if status=='C' or status=='E':
			if (outputs !=None):
				msg=Job.FetchOutput(id,owner,outputs)
				res = Connect.Send(msg)
				return Job.parseResponse(res)
			else:
				return "COMPLETED"
def run(excuter):
	
	PIPE=subprocess.PIPE
	p=subprocess.Popen(excuter,stdout=PIPE,stderr=PIPE,shell=True)
	p.wait()
	st=p.stderr.read()
	
	if (len(st)>0):
#		print "ERR: " + st	
		return "ERR: " + st		
	return p.stdout.read()


#def addNode(node, domain):
#	file=open(mainPath+'serversList','a')
#	file.write(node + " " + domain + '\n')
#	file.flush()
#	file.close()
	
def terminateNode(pkey,cert,region,id):

	run (mainPath +"EC2 " +  pkey + " " + cert + " " + region + " --terminate " + id)
	_insert("update EC2Instances set EC2Instances.Terminated=1 where instanceID='" + id+"'")
	
def log(file,line):
	f=open(file,'a')
	f.write(line+'\n')
	f.flush()
	f.close()

def getUserAWSConf(path):
	conf = ConfigParser.RawConfigParser()
	conf.read(path)
	dict={}
	dict["pkeyfile"]=conf.get('aws','pkey')
	dict["certfile"]=conf.get('aws','cert')
	dict["accessKey"]=conf.get('aws','accessKey')
	dict["secretKey"]=conf.get('aws','secretKey')
	s3pass='/'.join(path.split('/')[:-1])+"/.passwd-s3fs"
	file=open(s3pass,'w')
	file.write(dict["accessKey"]+":"+dict["secretKey"])
	file.flush()
	file.close()
	dict["s3passwd"]=s3pass
	return dict

def createCluster(region,cores,awsfile,sshKey,group, s3,ClusterName):
		global domain,logFile
		print "In create mode....."
		print awsfile
		aws=getUserAWSConf(awsfile)
		#UUID=awsfile.split('/')[-1].split('.')[0]
		#cores=int(cores)
		#if (cores>8):
		#	c=8
		#else: c=cores
		comm= mainPath+"EC2 " + aws["pkeyfile"] + " " + aws["certfile"] + " " + region + " --create " + cores.split('-')[0]  + " 1 " + sshKey + " " + group
		
		log(logFile,"Starting the master node this may take up to 2 minutes")
			
		
		text = run (comm) #Start Node
		if ("ERR: " in text):
			print text.strip()
			sys.exit(1)		
		lines=text.split("INSTANCE")

#		print "Lines: " , lines[1:]
		nodes=[]
		for line in lines[1:]:
	#		print "Line: " + line
			p=line.split(" ")
			log(logFile,"Master Node ID: " + p[1])
			print "InstanceID = "+p[1] +"\n"
			nodes.append(p[1])
		
	#	print "nodes IDs:" , nodes	
		info={}	
		privateIP=""
		for node in nodes:
			t = run(mainPath+"EC2 "+ aws["pkeyfile"] + " " + aws["certfile"] + " "+ region + " --details " + node)
			print t
			lines=t.split("\n")
			for line in lines:
				if "URL = " in line:
					
					domain = line.split("= ")[1].strip()[1:-1]
	#				print "Create a new cluster at : " , domain
#					addNode(node,domain)
				#if ("Private IP = " in line):
				#	privateIP = line.split ("= ")[1].strip()
	#				print "MasterNode IP '" + privateIP +"'"
			log(logFile,"Master Node started Successfully")
			if (clusterName!=""):
				from time import gmtime, strftime
				ctime = strftime("%d %m %Y %H:%M:%S +0000", gmtime())	
				st= "Insert into EC2Instances (UUID,DNS,instanceID,StartOn,region,Cores,Name) values('" + UUID + "', '"+ domain + "','" + nodes[0]+"','"+ctime +"','" + region + "','" + str(cores) +"','" + ClusterName +"')"
				_insert(st)
			time.sleep(30)
		
	#return st
		
		log(logFile,"Install New cluster at:" + domain + ".... May take take up to 5 mins" )
		_installCluster(cores.split("-")[1],sshKey,group,s3,aws["pkeyfile"] , aws["certfile"],aws["s3passwd"])
		time.sleep(10)
		log (logFile , "Completed Successfully")
		print "Completed Successfully"
		return domain
def terminateCluster(awsConf,domain):
	#global domain
 	#domain=sys.argv[2]
 	conf=getUserAWSConf(awsConf)
	print sendNewJob(domain,"10","system","/root/HPCloud/terminateCluster.py --sucide")
	#terminateNode(conf['pkeyfile'],conf['certfile'],region,id,)
	return "Done"

def _installCluster(cores,sshKey,group,s3,pk,cert,s3passwd):
	global domain
	
	#print sendNewJob(domain,"1","system","/root/installTorque.py")
	Command="/root/HPCloud/createCluster.py 'EU-Cluster5-0' '" + cores + "' '"+ s3 + "' '"+sshKey + "' '" +group+"' '"+   pk + "' '" + cert+"' '"+s3passwd  +"'" 
	print "Command:", Command
	print sendNewJob(domain,"3","system",Command,[pk,cert,s3passwd])

if __name__ =="__main__":
	if sys.argv[1]=="--create":
		logFile='logs/cluster.log'
		confName=sys.argv[2]
		region=sys.argv[3]
		cores=sys.argv[4]
		sshKey=sys.argv[5]
		group=sys.argv[6]
		s3=sys.argv[7]
		clusterName=sys.argv[8]
		
		domain= createCluster(region,cores,"/home/mohamed/amazon/emr/MyScripts/Client/conf/" + confName + ".conf",sshKey,group,s3,clusterName)
		#print sendNewJob(domain,"1",'mkalioby',"sleep 10;cat < /results/2429/input1_21 > /results/2429/res.txt",['/results/2429/input1_21'],['/results/2429/res.txt'])
		print "URL: " + domain
	elif (sys.argv[1]=="--install"):
		domain= sys.argv[2]
		confName=sys.argv[3]
		cores=sys.argv[4]
		
		aws=getUserAWSConf("conf/" + confName + ".conf")
		sshKey=sys.argv[5]
		group=sys.argv[6]
		s3=sys.argv[7]
		ClusterName=sys.argv[8]
		_installCluster(str(cores),sshKey,group,s3,aws["pkeyfile"],aws["certfile"],aws["s3passwd"])
	elif (sys.argv[1]=="--run") :
		domain=sys.argv[2]
		print sendNewJob(domain,"1",'mkalioby',"sleep 10;cat < /results/2429/input1_21 > /results/2429/res.txt",['/results/2429/input1_21'],['/results/2429/res.txt'])
	elif (sys.argv[1]=="--terminate"):
		#domain,pkey,cert,region
		confName=sys.argv[3]
		aws="conf/" + confName + ".conf"
		domain = sys.argv[2]
		#region=sys.argv[4]
		
		print "Terminating Cluster at: '" + domain+"'"
		terminateCluster(aws,domain)
